import React from "react";
import "./Cities.css";

export default function Cities() {
 
  const cities = [
    {
      id: 1,
      name: "Karachi",
      province: "Sindh",
      zones: 18,
      status: "Active",
    },
    {
      id: 2,
      name: "Lahore",
      province: "Punjab",
      zones: 12,
      status: "Active",
    },
    {
      id: 3,
      name: "Islamabad",
      province: "ICT",
      zones: 6,
      status: "Active",
    },
    {
      id: 4,
      name: "Quetta",
      province: "Balochistan",
      zones: 4,
      status: "Inactive",
    },
    {
      id: 5,
      name: "Peshawar",
      province: "KPK",
      zones: 7,
      status: "Active",
    },
  ];

  return (
    <div className="page-card">
      <div className="page-header">
        <h2 className="page-title">
          Cities
          <span className="count-badge">{cities.length}</span>
        </h2>

        <button className="primary-btn">+ Add City</button>
      </div>

      <div className="table-wrapper">
        <table className="data-table">
          <thead>
            <tr>
              <th>#</th>
              <th>City Name</th>
              <th>Province</th>
              <th>Total Zones</th>
              <th>Status</th>
              <th>Actions</th>
            </tr>
          </thead>

          <tbody>
            {cities.map((city, index) => (
              <tr key={city.id}>
                <td>{index + 1}</td>
                <td>{city.name}</td>
                <td>{city.province}</td>
                <td>{city.zones}</td>
                <td>
                  <span
                    className={`status-badge ${
                      city.status === "Active" ? "active" : "inactive"
                    }`}
                  >
                    {city.status}
                  </span>
                </td>
                <td className="action-cell">
                  <button className="action-btn edit">Edit</button>
                  <button className="action-btn delete">Delete</button>
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  );
}
