import React from "react";
import { User, Mail, Phone } from "lucide-react";
import "./Profile.css";

const EditProfile = () => {
  return (
    <div className="edit-profile-center">
      <form className="profile-form modern">
        <h3 className="form-title">Edit Profile</h3>

        <div className="form-group">
          <label>Name</label>
          <div className="input-box">
            <User size={18} />
            <input type="text" placeholder="Your Name" />
          </div>
        </div>

        <div className="form-group">
          <label>Email</label>
          <div className="input-box">
            <Mail size={18} />
            <input type="email" placeholder="Email Address" />
          </div>
        </div>

        <div className="form-group">
          <label>Phone</label>
          <div className="input-box">
            <Phone size={18} />
            <input type="text" placeholder="Phone Number" />
          </div>
        </div>

        <button type="submit" className="primary-btn glow">
          Save Changes
        </button>
      </form>
    </div>
  );
};

export default EditProfile;
