import React from "react";
import "./SearchBar.css";

export default function SearchBar({
  searchValue,
  onSearchChange,
  customer,
  onCustomerChange,
  onSearchSubmit,
}) {
  return (
    <div className="header">
      <input
        type="text"
        className="search-input"
        placeholder="Search Order"
        value={searchValue}
        onChange={(e) => onSearchChange(e.target.value)}
      />

      <select
        className="customer-select"
        value={customer}
        onChange={(e) => onCustomerChange(e.target.value)}
      >
        <option value="">All Customers</option>
        <option value="customer1">Customer 1</option>
        <option value="customer2">Customer 2</option>
      </select>
    </div>
  );
}
