import React from "react";
import "./Couriers.css";

export default function Couriers() {

  const couriers = [
    {
      id: 1,
      name: "Leopards Courier",
      contact: "042-111-300-786",
      email: "support@leopards.com.pk",
      cities: 120,
      status: "Active",
    },
    {
      id: 2,
      name: "TCS Express",
      contact: "021-111-123-456",
      email: "info@tcs.com.pk",
      cities: 150,
      status: "Active",
    },
    {
      id: 3,
      name: "Call Courier",
      contact: "042-35761999",
      email: "support@callcourier.com.pk",
      cities: 90,
      status: "Inactive",
    },
    {
      id: 4,
      name: "BlueEx",
      contact: "021-111-258-339",
      email: "help@blue-ex.com",
      cities: 110,
      status: "Active",
    },
  ];

  return (
    <div className="page-card">
      <div className="page-header">
        <h2 className="page-title">
          Couriers
          <span className="count-badge">{couriers.length}</span>
        </h2>

        <button className="primary-btn">+ Add Courier</button>
      </div>

      <div className="table-wrapper">
        <table className="data-table">
          <thead>
            <tr>
              <th>#</th>
              <th>Courier Name</th>
              <th>Contact</th>
              <th>Email</th>
              <th>Cities Covered</th>
              <th>Status</th>
              <th>Actions</th>
            </tr>
          </thead>

          <tbody>
            {couriers.map((courier, index) => (
              <tr key={courier.id}>
                <td>{index + 1}</td>
                <td>{courier.name}</td>
                <td>{courier.contact}</td>
                <td>{courier.email}</td>
                <td>{courier.cities}</td>
                <td>
                  <span
                    className={`status-badge ${
                      courier.status === "Active" ? "active" : "inactive"
                    }`}
                  >
                    {courier.status}
                  </span>
                </td>
                <td className="action-cell">
                  <button className="action-btn edit">Edit</button>
                  <button className="action-btn delete">Delete</button>
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  );
}
