import React from "react";
import "./Customers.css";

export default function ActiveCustomers() {
 
  const customers = [
    {
      id: 1,
      name: "Muhammad Idrees",
      company: "IT Vision Pvt Ltd",
      phone: "0332-4510131",
      email: "info@itvision.com.pk",
      city: "Lahore",
      totalOrders: 128,
      status: "Active",
    },
    {
      id: 2,
      name: "Ali Khan",
      company: "Tech Solutions",
      phone: "0301-9876543",
      email: "ali@tech.com",
      city: "Karachi",
      totalOrders: 76,
      status: "Active",
    },
    {
      id: 3,
      name: "Ayesha Noor",
      company: "Online Store",
      phone: "0345-1122334",
      email: "ayesha@store.com",
      city: "Islamabad",
      totalOrders: 54,
      status: "Active",
    },
  ];

  return (
    <div className="page-card">
      <h2 className="page-title">
        Active Customers
        <span className="count-badge">{customers.length}</span>
      </h2>

      <div className="customer-grid">
        {customers.map((cust) => (
          <div key={cust.id} className="customer-card">
            <div className="customer-header">
              <h3>{cust.name}</h3>
              <span className="status active">{cust.status}</span>
            </div>

            <p className="company">{cust.company}</p>

            <div className="customer-info">
              <p><b>Phone:</b> {cust.phone}</p>
              <p><b>Email:</b> {cust.email}</p>
              <p><b>City:</b> {cust.city}</p>
            </div>

            <div className="customer-footer">
              <span className="orders">
                📦 Orders: <b>{cust.totalOrders}</b>
              </span>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
}
