import React, { useState } from "react";
import PendingCustomers from "./PendingCustomers";
import ActiveCustomers from "./ActiveCustomers";

export default function Customers() {
  const [tab, setTab] = useState("pending");

  return (
    <div className="page-card">
      <h2 className="page-title">Customers</h2>

      {/* 🔹 Tabs */}
      <div style={styles.tabs}>
        <button
          style={{
            ...styles.tabBtn,
            ...(tab === "pending" ? styles.active : {}),
          }}
          onClick={() => setTab("pending")}
        >
          Pending Customers
        </button>

        <button
          style={{
            ...styles.tabBtn,
            ...(tab === "active" ? styles.active : {}),
          }}
          onClick={() => setTab("active")}
        >
          Active Customers
        </button>
      </div>

      {/* 🔹 Content */}
      <div style={{ marginTop: 20 }}>
        {tab === "pending" && <PendingCustomers />}
        {tab === "active" && <ActiveCustomers />}
      </div>
    </div>
  );
}

const styles = {
  tabs: {
    display: "flex",
    gap: 10,
    marginTop: 15,
  },
  tabBtn: {
    padding: "8px 18px",
    border: "1px solid #ddd",
    background: "#f5f6fa",
    cursor: "pointer",
    borderRadius: 6,
    fontWeight: 500,
  },
  active: {
    background: "#1e90ff",
    color: "#fff",
    border: "1px solid #1e90ff",
  },
};
