import React from "react";
import "./Payments.css";

export default function CustomerPayments() {

  const payments = [
    {
      id: 1,
      customer: "Muhammad Idrees",
      company: "IT Vision Pvt Ltd",
      orderNo: "ORD-20021",
      amount: 8799,
      paymentType: "COD",
      status: "Pending",
      date: "12 Mar 2024",
    },
    {
      id: 2,
      customer: "Ali Khan",
      company: "Tech Solutions",
      orderNo: "ORD-20022",
      amount: 5000,
      paymentType: "Bank Transfer",
      status: "Paid",
      date: "10 Mar 2024",
    },
    {
      id: 3,
      customer: "Ayesha Noor",
      company: "Online Store",
      orderNo: "ORD-20023",
      amount: 3200,
      paymentType: "COD",
      status: "Pending",
      date: "09 Mar 2024",
    },
  ];

  return (
    <div className="page-card">
      <h2 className="page-title">
        Customer Payments
        <span className="count-badge">{payments.length}</span>
      </h2>

      <div className="table-wrapper">
        <table className="data-table">
          <thead>
            <tr>
              <th>#</th>
              <th>Customer</th>
              <th>Company</th>
              <th>Order No</th>
              <th>Amount (Rs)</th>
              <th>Payment Type</th>
              <th>Status</th>
              <th>Date</th>
            </tr>
          </thead>

          <tbody>
            {payments.map((pay, index) => (
              <tr key={pay.id}>
                <td>{index + 1}</td>
                <td>{pay.customer}</td>
                <td>{pay.company}</td>
                <td>{pay.orderNo}</td>
                <td>{pay.amount.toLocaleString()}</td>
                <td>{pay.paymentType}</td>
                <td>
                  <span
                    className={`status-badge ${
                      pay.status === "Paid" ? "paid" : "pending"
                    }`}
                  >
                    {pay.status}
                  </span>
                </td>
                <td>{pay.date}</td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  );
}
