import React from "react";
import "./Pricing.css";

export default function Pricing() {
 
  const pricing = [
    {
      id: 1,
      city: "Karachi",
      weightFrom: "0 - 0.5 KG",
      deliveryFee: 180,
      codCharges: 50,
      returnCharges: 120,
      status: "Active",
    },
    {
      id: 2,
      city: "Lahore",
      weightFrom: "0 - 0.5 KG",
      deliveryFee: 200,
      codCharges: 60,
      returnCharges: 140,
      status: "Active",
    },
    {
      id: 3,
      city: "Islamabad",
      weightFrom: "0 - 0.5 KG",
      deliveryFee: 220,
      codCharges: 70,
      returnCharges: 160,
      status: "Active",
    },
    {
      id: 4,
      city: "Quetta",
      weightFrom: "0 - 0.5 KG",
      deliveryFee: 300,
      codCharges: 80,
      returnCharges: 200,
      status: "Inactive",
    },
  ];

  return (
    <div className="page-card">
 
      <div className="page-header">
        <h2 className="page-title">
          Pricing
          <span className="count-badge">{pricing.length}</span>
        </h2>

        <button className="primary-btn">+ Add Pricing</button>
      </div>

   
      <div className="table-wrapper">
        <table className="data-table">
          <thead>
            <tr>
              <th>#</th>
              <th>City</th>
              <th>Weight Slab</th>
              <th>Delivery Fee (Rs)</th>
              <th>COD Charges (Rs)</th>
              <th>Return Charges (Rs)</th>
              <th>Status</th>
              <th>Actions</th>
            </tr>
          </thead>

          <tbody>
            {pricing.map((item, index) => (
              <tr key={item.id}>
                <td>{index + 1}</td>
                <td>{item.city}</td>
                <td>{item.weightFrom}</td>
                <td>{item.deliveryFee}</td>
                <td>{item.codCharges}</td>
                <td>{item.returnCharges}</td>
                <td>
                  <span
                    className={`status-badge ${
                      item.status === "Active" ? "active" : "inactive"
                    }`}
                  >
                    {item.status}
                  </span>
                </td>
                <td className="action-cell">
                  <button className="action-btn edit">Edit</button>
                  <button className="action-btn delete">Delete</button>
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  );
}
