import React from "react";
import "./OrderReport.css";

export default function OrderReport() {
 
  const reports = [
    {
      id: 1,
      orderNo: "ORD-301",
      customer: "Muhammad Idrees",
      city: "Lahore",
      status: "Delivered",
      amount: 8799,
      date: "12 Mar 2024",
    },
    {
      id: 2,
      orderNo: "ORD-302",
      customer: "Ali Khan",
      city: "Karachi",
      status: "Pending",
      amount: 4200,
      date: "11 Mar 2024",
    },
    {
      id: 3,
      orderNo: "ORD-303",
      customer: "Sara Noor",
      city: "Islamabad",
      status: "Returned",
      amount: 3200,
      date: "10 Mar 2024",
    },
    {
      id: 4,
      orderNo: "ORD-304",
      customer: "Usman Ali",
      city: "Lahore",
      status: "Cancelled",
      amount: 5600,
      date: "09 Mar 2024",
    },
  ];

  return (
    <div className="page-card">
      <h2 className="page-title">
        Order Report
        <span className="count-badge">{reports.length}</span>
      </h2>

     
      <div className="filter-bar">
        <select>
          <option>All Status</option>
          <option>Delivered</option>
          <option>Pending</option>
          <option>Returned</option>
          <option>Cancelled</option>
        </select>

        <select>
          <option>All Cities</option>
          <option>Lahore</option>
          <option>Karachi</option>
          <option>Islamabad</option>
        </select>

        <input type="date" />
        <input type="date" />

        <button className="filter-btn">Apply</button>
      </div>

      <div className="table-wrapper">
        <table className="data-table">
          <thead>
            <tr>
              <th>#</th>
              <th>Order No</th>
              <th>Customer</th>
              <th>City</th>
              <th>Status</th>
              <th>Amount (Rs)</th>
              <th>Date</th>
            </tr>
          </thead>

          <tbody>
            {reports.map((row, index) => (
              <tr key={row.id}>
                <td>{index + 1}</td>
                <td>{row.orderNo}</td>
                <td>{row.customer}</td>
                <td>{row.city}</td>
                <td>
                  <span className={`status-badge ${row.status.toLowerCase()}`}>
                    {row.status}
                  </span>
                </td>
                <td>{row.amount.toLocaleString()}</td>
                <td>{row.date}</td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  );
}
