import React from "react";
import "./ShipmentReport.css";

export default function ShipmentReport() {

  const shipments = [
    {
      id: 1,
      trackingNo: "TRK-9001",
      orderNo: "ORD-401",
      customer: "Muhammad Idrees",
      courier: "Leopards",
      city: "Lahore",
      status: "In Transit",
      weight: "0.5 kg",
      date: "12 Mar 2024",
    },
    {
      id: 2,
      trackingNo: "TRK-9002",
      orderNo: "ORD-402",
      customer: "Ali Khan",
      courier: "TCS",
      city: "Karachi",
      status: "Delivered",
      weight: "1 kg",
      date: "11 Mar 2024",
    },
    {
      id: 3,
      trackingNo: "TRK-9003",
      orderNo: "ORD-403",
      customer: "Sara Noor",
      courier: "Call Courier",
      city: "Islamabad",
      status: "Returned",
      weight: "0.75 kg",
      date: "10 Mar 2024",
    },
    {
      id: 4,
      trackingNo: "TRK-9004",
      orderNo: "ORD-404",
      customer: "Usman Ali",
      courier: "BlueEx",
      city: "Lahore",
      status: "Pending",
      weight: "2 kg",
      date: "09 Mar 2024",
    },
  ];

  return (
    <div className="page-card">
      <h2 className="page-title">
        Shipment Report
        <span className="count-badge">{shipments.length}</span>
      </h2>

    
      <div className="filter-bar">
        <select>
          <option>All Status</option>
          <option>Pending</option>
          <option>In Transit</option>
          <option>Delivered</option>
          <option>Returned</option>
        </select>

        <select>
          <option>All Couriers</option>
          <option>Leopards</option>
          <option>TCS</option>
          <option>Call Courier</option>
          <option>BlueEx</option>
        </select>

        <input type="date" />
        <input type="date" />

        <button className="filter-btn">Apply</button>
      </div>

      <div className="table-wrapper">
        <table className="data-table">
          <thead>
            <tr>
              <th>#</th>
              <th>Tracking No</th>
              <th>Order No</th>
              <th>Customer</th>
              <th>Courier</th>
              <th>City</th>
              <th>Status</th>
              <th>Weight</th>
              <th>Date</th>
            </tr>
          </thead>

          <tbody>
            {shipments.map((row, index) => (
              <tr key={row.id}>
                <td>{index + 1}</td>
                <td>{row.trackingNo}</td>
                <td>{row.orderNo}</td>
                <td>{row.customer}</td>
                <td>{row.courier}</td>
                <td>{row.city}</td>
                <td>
                  <span className={`status-badge ${row.status.toLowerCase().replace(" ", "-")}`}>
                    {row.status}
                  </span>
                </td>
                <td>{row.weight}</td>
                <td>{row.date}</td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  );
}
