import { useEffect } from "react";

export default function Assigned({ setCounts }) {


  const data = [
    { id: 101, orderNo: "ORD-101", customer: "Ali Khan", city: "Karachi" },
    { id: 102, orderNo: "ORD-102", customer: "Ahmed Raza", city: "Lahore" },
    { id: 103, orderNo: "ORD-103", customer: "Sara Noor", city: "Islamabad" },
    { id: 104, orderNo: "ORD-104", customer: "Usman Ali", city: "Karachi" },
  ];

  useEffect(() => {
    setCounts(prev => ({
      ...prev,
      assigned: data.length,
    }));
  }, []);

  return (
    <div className="page-card">
      <h2 className="page-title">
        Assigned Orders <span className="count-badge">{data.length}</span>
      </h2>

      <table className="data-table">
        <thead>
          <tr>
            <th>#</th>
            <th>Order No</th>
            <th>Customer</th>
            <th>City</th>
          </tr>
        </thead>
        <tbody>
          {data.map((item, index) => (
            <tr key={item.id}>
              <td>{index + 1}</td>
              <td>{item.orderNo}</td>
              <td>{item.customer}</td>
              <td>{item.city}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}

