import React, { useEffect } from "react";
import "./BookOrders.css"; 

const BookOrders = ({ setCounts }) => {

 
  const orders = [
    {
      orderNo: "30000011",
      date: "20 Aug 2024",
      time: "02:45 PM",
      sender: {
        name: "Ali Khan",
        company: "Tech Solutions",
        phone: "03001234567",
        email: "ali@tech.com",
        address: "Gulshan-e-Iqbal, Karachi",
      },
      receiver: {
        name: "Ahmed Raza",
        phone: "03112223333",
        address: "Model Town, Lahore",
      },
      shipment: {
        tracking: "-",
        productCode: "PK-001",
        weight: "1 KG",
        description: "Electronics",
      },
      payment: {
        deliveryFee: "250",
        cod: "12,500",
      },
    },
    {
      orderNo: "30000012",
      date: "21 Aug 2024",
      time: "11:20 AM",
      sender: {
        name: "Sara Ahmed",
        company: "Online Store",
        phone: "03221112222",
        email: "sara@store.com",
        address: "Johar Town, Lahore",
      },
      receiver: {
        name: "Usman Ali",
        phone: "03009998888",
        address: "Saddar, Rawalpindi",
      },
      shipment: {
        tracking: "-",
        productCode: "PK-002",
        weight: "0.7 KG",
        description: "Clothes",
      },
      payment: {
        deliveryFee: "200",
        cod: "4,800",
      },
    },
  ];


  useEffect(() => {
    if (typeof setCounts === "function") {
      setCounts(prev => ({
        ...prev,
        newOrders: orders.length,
      }));
    }
  }, [setCounts]);

  return (
    <div className="table-section">
      <h2 className="table-title">
        📦 Booked Orders (Recent {orders.length})
      </h2>

      <div className="table-wrapper">
        <table className="orders-table">
          <thead>
            <tr>
              <th>Order #</th>
              <th>Order Date</th>
              <th>Order Time</th>
              <th>Sender Details</th>
              <th>Receiver Details</th>
              <th>Shipment Details</th>
              <th>Payments</th>
            </tr>
          </thead>

          <tbody>
            {orders.map((order, index) => (
              <tr key={index}>
                <td>{order.orderNo}</td>
                <td>{order.date}</td>
                <td>{order.time}</td>

                <td>
                  <b>Name:</b> {order.sender.name} <br />
                  <b>Company:</b> {order.sender.company} <br />
                  <b>Phone:</b> {order.sender.phone} <br />
                  <b>Email:</b> {order.sender.email} <br />
                  <b>Address:</b> {order.sender.address}
                </td>

                <td>
                  <b>Name:</b> {order.receiver.name} <br />
                  <b>Phone:</b> {order.receiver.phone} <br />
                  <b>Address:</b> {order.receiver.address}
                </td>

                <td>
                  <b>Tracking:</b> {order.shipment.tracking} <br />
                  <b>Product Code:</b> {order.shipment.productCode} <br />
                  <b>Parcel Weight:</b> {order.shipment.weight} <br />
                  <b>Description:</b> {order.shipment.description}
                </td>

                <td>
                  <b>Delivery Fees:</b> Rs {order.payment.deliveryFee} <br />
                  <b>COD Amount:</b> Rs {order.payment.cod}
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  );
};

export default BookOrders;
