import { useEffect } from "react";

export default function Cancelled({ setCounts }) {


  const data = [
    { id: 301, orderNo: "ORD-301", customer: "Bilal Ahmed", city: "Islamabad" },
    { id: 302, orderNo: "ORD-302", customer: "Nida Fatima", city: "Karachi" },
    { id: 303, orderNo: "ORD-303", customer: "Saad Khan", city: "Lahore" },
  ];

  useEffect(() => {
    if (typeof setCounts === "function") {
      setCounts(prev => ({
        ...prev,
        cancelled: data.length,
      }));
    }
  }, []);

  return (
    <div className="page-card">
      <h2 className="page-title">
        Cancelled Orders <span className="count-badge">{data.length}</span>
      </h2>

      <table className="data-table">
        <thead>
          <tr>
            <th>#</th>
            <th>Order No</th>
            <th>Customer</th>
            <th>City</th>
          </tr>
        </thead>
        <tbody>
          {data.map((item, index) => (
            <tr key={item.id}>
              <td>{index + 1}</td>
              <td>{item.orderNo}</td>
              <td>{item.customer}</td>
              <td>{item.city}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}
