import { useEffect } from "react";

export default function Delivered({ setCounts }) {


  const data = [
    { id: 701, orderNo: "ORD-701", customer: "Imran Khan", city: "Karachi" },
    { id: 702, orderNo: "ORD-702", customer: "Ayesha Noor", city: "Lahore" },
    { id: 703, orderNo: "ORD-703", customer: "Usama Malik", city: "Faisalabad" },
    { id: 704, orderNo: "ORD-704", customer: "Hira Shah", city: "Islamabad" },
    { id: 705, orderNo: "ORD-705", customer: "Saad Ali", city: "Multan" },
  ];

  useEffect(() => {
    if (typeof setCounts === "function") {
      setCounts(prev => ({
        ...prev,
        delivered: data.length,
      }));
    }
  }, []);

  return (
    <div className="page-card">
      <h2 className="page-title">
        Delivered Orders <span className="count-badge">{data.length}</span>
      </h2>

      <table className="data-table">
        <thead>
          <tr>
            <th>#</th>
            <th>Order No</th>
            <th>Customer</th>
            <th>City</th>
          </tr>
        </thead>

        <tbody>
          {data.map((item, index) => (
            <tr key={item.id}>
              <td>{index + 1}</td>
              <td>{item.orderNo}</td>
              <td>{item.customer}</td>
              <td>{item.city}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}
