import { useEffect } from "react";

export default function Dispatch({ setCounts }) {

 
  const data = [
    { id: 401, orderNo: "ORD-401", customer: "Imran Khan", city: "Karachi" },
    { id: 402, orderNo: "ORD-402", customer: "Zain Ali", city: "Lahore" },
    { id: 403, orderNo: "ORD-403", customer: "Hira Shah", city: "Faisalabad" },
    { id: 404, orderNo: "ORD-404", customer: "Usama Raza", city: "Islamabad" },
  ];

  useEffect(() => {
    if (typeof setCounts === "function") {
      setCounts(prev => ({
        ...prev,
        dispatch: data.length,
      }));
    }
  }, []);

  return (
    <div className="page-card">
      <h2 className="page-title">
        Dispatch Orders <span className="count-badge">{data.length}</span>
      </h2>

      <table className="data-table">
        <thead>
          <tr>
            <th>#</th>
            <th>Order No</th>
            <th>Customer</th>
            <th>City</th>
          </tr>
        </thead>

        <tbody>
          {data.map((item, index) => (
            <tr key={item.id}>
              <td>{index + 1}</td>
              <td>{item.orderNo}</td>
              <td>{item.customer}</td>
              <td>{item.city}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}
