import { useEffect } from "react";

export default function Karachi({ setCounts }) {


  const data = [
    { id: 401, orderNo: "ORD-401", customer: "Ali Raza", city: "Lahore" },
    { id: 402, orderNo: "ORD-402", customer: "Hassan Ahmed", city: "Lahore" },
    { id: 403, orderNo: "ORD-403", customer: "Fatima Noor", city: "Lahore" },
    { id: 404, orderNo: "ORD-404", customer: "Bilal Khan", city: "Lahore" },
  ];

  useEffect(() => {
    if (typeof setCounts === "function") {
      setCounts(prev => ({
        ...prev,
        karachi: data.length, 
      }));
    }
  }, []);

  return (
    <div className="page-card">
      <h2 className="page-title">
        Item Received for Lahore{" "}
        <span className="count-badge">{data.length}</span>
      </h2>

      <table className="data-table">
        <thead>
          <tr>
            <th>#</th>
            <th>Order No</th>
            <th>Customer</th>
            <th>City</th>
          </tr>
        </thead>

        <tbody>
          {data.map((item, index) => (
            <tr key={item.id}>
              <td>{index + 1}</td>
              <td>{item.orderNo}</td>
              <td>{item.customer}</td>
              <td>{item.city}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}
