import { useEffect } from "react";

export default function Cancelled({ setCounts }) {


  const data = [
    {
      orderId: "ORD-1001",
      customer: "Ali Traders",
      reason: "Customer not available",
      date: "2025-01-10",
    },
    {
      orderId: "ORD-1002",
      customer: "Khan Store",
      reason: "Address incorrect",
      date: "2025-01-11",
    },
    {
      orderId: "ORD-1003",
      customer: "Zahid Mart",
      reason: "Order cancelled by customer",
      date: "2025-01-12",
    },
  ];


  useEffect(() => {
    setCounts((prev) => ({
      ...prev,
      cancelled: data.length,
    }));
  }, [data.length, setCounts]);

  return (
    <div>
      <h2>Cancelled Orders ({data.length})</h2>

      <table className="orders-table">
        <thead>
          <tr>
            <th>Order ID</th>
            <th>Customer</th>
            <th>Reason</th>
            <th>Date</th>
          </tr>
        </thead>

        <tbody>
          {data.map((item, index) => (
            <tr key={index}>
              <td>{item.orderId}</td>
              <td>{item.customer}</td>
              <td>{item.reason}</td>
              <td>{item.date}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}
