import { useEffect } from "react";

export default function Outstation({ setCounts }) {


  const data = [
    { id: 501, orderNo: "ORD-501", customer: "Usman Ali", city: "Multan" },
    { id: 502, orderNo: "ORD-502", customer: "Ayesha Khan", city: "Peshawar" },
    { id: 503, orderNo: "ORD-503", customer: "Saad Ahmed", city: "Quetta" },
    { id: 504, orderNo: "ORD-504", customer: "Hina Malik", city: "Faisalabad" },
  ];

  useEffect(() => {
    if (typeof setCounts === "function") {
      setCounts(prev => ({
        ...prev,
        outstation: data.length, 
      }));
    }
  }, []);

  return (
    <div className="page-card">
      <h2 className="page-title">
        Item Received for Outstation{" "}
        <span className="count-badge">{data.length}</span>
      </h2>

      <table className="data-table">
        <thead>
          <tr>
            <th>#</th>
            <th>Order No</th>
            <th>Customer</th>
            <th>City</th>
          </tr>
        </thead>

        <tbody>
          {data.map((item, index) => (
            <tr key={item.id}>
              <td>{index + 1}</td>
              <td>{item.orderNo}</td>
              <td>{item.customer}</td>
              <td>{item.city}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}
