import { useEffect } from "react";

export default function PendingOrders({ setCounts }) {

  
  const data = [
    { id: 501, orderNo: "ORD-501", customer: "Ahsan Ali", city: "Karachi" },
    { id: 502, orderNo: "ORD-502", customer: "Bilal Ahmed", city: "Lahore" },
    { id: 503, orderNo: "ORD-503", customer: "Sana Malik", city: "Multan" },
    { id: 504, orderNo: "ORD-504", customer: "Hamza Khan", city: "Islamabad" },
  ];

  useEffect(() => {
    if (typeof setCounts === "function") {
      setCounts(prev => ({
        ...prev,
        pendingOrders: data.length,
      }));
    }
  }, []);

  return (
    <div className="page-card">
      <h2 className="page-title">
        Pending Orders <span className="count-badge">{data.length}</span>
      </h2>

      <table className="data-table">
        <thead>
          <tr>
            <th>#</th>
            <th>Order No</th>
            <th>Customer</th>
            <th>City</th>
          </tr>
        </thead>

        <tbody>
          {data.map((item, index) => (
            <tr key={item.id}>
              <td>{index + 1}</td>
              <td>{item.orderNo}</td>
              <td>{item.customer}</td>
              <td>{item.city}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}
