import { useEffect } from "react";

export default function Returned({ setCounts }) {


  const data = [
    { id: 201, orderNo: "ORD-201", customer: "Hassan Ali", city: "Lahore" },
    { id: 202, orderNo: "ORD-202", customer: "Ayesha Khan", city: "Karachi" },
  ];

  useEffect(() => {
    if (typeof setCounts === "function") {
      setCounts(prev => ({
        ...prev,
        returned: data.length,
      }));
    }
  }, []);

  return (
    <div className="page-card">
      <h2 className="page-title">
        Returned Orders <span className="count-badge">{data.length}</span>
      </h2>

      <table className="data-table">
        <thead>
          <tr>
            <th>#</th>
            <th>Order No</th>
            <th>Customer</th>
            <th>City</th>
          </tr>
        </thead>
        <tbody>
          {data.map((item, index) => (
            <tr key={item.id}>
              <td>{index + 1}</td>
              <td>{item.orderNo}</td>
              <td>{item.customer}</td>
              <td>{item.city}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}
